/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUtils {
    private static final Map<ResourceLocation, Integer> CACHE_FLUID_COLOR = new HashMap<ResourceLocation, Integer>();

    @OnlyIn(value=Dist.CLIENT)
    public static void clearCacheFluidColor() {
        CACHE_FLUID_COLOR.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getAverageFluidColor(Fluid fluid) {
        int fluidColor = -1;
        Integer colorCashed = CACHE_FLUID_COLOR.get(fluid.getRegistryName());
        if (colorCashed != null) {
            fluidColor = colorCashed;
        } else {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getFluid().getAttributes().getStillTexture());
            if (sprite != null) {
                long totalRed = 0L;
                long totalGreen = 0L;
                long totalBlue = 0L;
                int pixelCount = sprite.func_94211_a() * sprite.func_94216_b();
                for (int i = 0; i < sprite.func_94216_b(); ++i) {
                    for (int j = 0; j < sprite.func_94211_a(); ++j) {
                        int color = sprite.getPixelRGBA(0, j, i);
                        int red = color & 0xFF;
                        int green = color >> 8 & 0xFF;
                        int blue = color >> 16 & 0xFF;
                        totalRed += (long)(red * red);
                        totalGreen += (long)(green * green);
                        totalBlue += (long)(blue * blue);
                    }
                }
                fluidColor = ((int)Math.sqrt(totalRed / (long)pixelCount) & 0xFF) << 16 | ((int)Math.sqrt(totalGreen / (long)pixelCount) & 0xFF) << 8 | (int)Math.sqrt(totalBlue / (long)pixelCount) & 0xFF;
            }
            CACHE_FLUID_COLOR.put(fluid.getRegistryName(), fluidColor);
        }
        return fluidColor;
    }

    public static int transferFluid(IFluidHandler source, IFluidHandler target, int maxAmount) {
        int filled;
        FluidStack drained = source.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() > 0 && (filled = target.fill(drained, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            drained = source.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            return target.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawFluidTankInGUI(FluidStack fluid, double x, double y, double percent, int height) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            float deltaV = maxV - minV;
            double tankLevel = percent * (double)height;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            RenderSystem.enableBlend();
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int i = 0; i < count; ++i) {
                double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                double offsetY = (double)height - 16.0 * (double)i - subHeight;
                FluidUtils.drawQuad(x, y + offsetY, 16.0, subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
            }
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(x, y + height, 0.0).func_225583_a_(minU, maxV).func_181675_d();
        buffer.func_225582_a_(x + width, y + height, 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_225582_a_(x + width, y, 0.0).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_225582_a_(x, y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

